% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bayes_R2.R
\name{bayes_R2.stanreg}
\alias{bayes_R2.stanreg}
\alias{bayes_R2}
\alias{loo_R2.stanreg}
\alias{loo_R2}
\title{Compute a Bayesian version of R-squared or LOO-adjusted R-squared for
regression models.}
\usage{
\method{bayes_R2}{stanreg}(object, ..., re.form = NULL)

\method{loo_R2}{stanreg}(object, ...)
}
\arguments{
\item{object}{A fitted model object returned by one of the 
\pkg{rstanarm} modeling functions. See \code{\link{stanreg-objects}}.}

\item{...}{Currently ignored.}

\item{re.form}{For models with group-level terms, \code{re.form} is
passed to \code{\link{posterior_epred}} if specified.}
}
\value{
A vector of R-squared values with length equal to the posterior
  sample size (the posterior distribution of R-squared).
}
\description{
Compute a Bayesian version of R-squared or LOO-adjusted R-squared for
regression models.
}
\examples{
if (.Platform$OS.type != "windows" || .Platform$r_arch != "i386") {
fit <- stan_glm(
  mpg ~ wt + cyl, 
  data = mtcars, 
  QR = TRUE, 
  chains = 2, 
  refresh = 0
)
rsq <- bayes_R2(fit)
print(median(rsq))
hist(rsq)

loo_rsq <- loo_R2(fit)
print(median(loo_rsq))

# multilevel binomial model
if (!exists("example_model")) example(example_model)
print(example_model)
median(bayes_R2(example_model))
median(bayes_R2(example_model, re.form = NA)) # exclude group-level
}
}
\references{
Andrew Gelman, Ben Goodrich, Jonah Gabry, and Aki Vehtari (2019). R-squared
for Bayesian regression models. \emph{The American Statistician}, to appear.
\doi{10.1080/00031305.2018.1549100}
(\href{https://www.tandfonline.com/doi/abs/10.1080/00031305.2018.1549100}{Article},
\href{https://avehtari.github.io/bayes_R2/bayes_R2.html}{Notebook})
}
