% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert-tm-to-vs.R
\name{convert_tm_to_vs_theme}
\alias{convert_tm_to_vs_theme}
\title{Convert a TextMate theme into a Visual Studio Code/Positron theme}
\usage{
convert_tm_to_vs_theme(
  path,
  outfile = tempfile(fileext = ".json"),
  name = NULL,
  author = NULL
)
}
\arguments{
\item{path}{Path or URL to a TextMate theme, in \code{.tmTheme} format.}

\item{outfile}{Path where the resulting file will be written. By default
a temporary file (\code{\link[=tempfile]{tempfile()}}).}

\item{name}{Optional. The name of the theme. If not provided, the name of
the theme in \code{path} will be used.}

\item{author}{Optional. The author of the theme. If not provided, the author
from \code{path} will be used, or a default value will be assigned.}
}
\value{
This function is called for its side effects. It writes a new \code{.json}
file in \code{outfile} and returns the path.
}
\description{
Read a \code{.tmTheme} file representing a TextMate theme and write the
equivalent Visual Studio Code theme (\code{.json}).
}
\examples{
tmtheme <- system.file("ext/test.tmTheme",
  package = "rstudiothemes"
)
path <- convert_tm_to_vs_theme(tmtheme)

readLines(path) |>
  head(50) |>
  cat(sep = "\n")

}
\seealso{
Other functions for creating themes: 
\code{\link{convert_to_rstudio_theme}()},
\code{\link{convert_vs_to_tm_theme}()}
}
\concept{functions for creating themes}
