% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate-uuid.R
\name{generate_uuid}
\alias{generate_uuid}
\title{Generate random UUIDs}
\source{
Heavily based on an unreleased version of \code{ids::uuid()}.
}
\usage{
generate_uuid(hint = NULL)
}
\arguments{
\item{hint}{Optional. A character string (or object coercible with
\code{\link[=as.character]{as.character()}}) to be used as a random seed.}
}
\value{
A character string representing a valid UUID that can be validated with
\code{\link[uuid:UUIDgenerate]{uuid::UUIDvalidate()}}.
}
\description{
Generate version 4 (pseudo-random) Universally Unique Identifiers (UUIDs).
}
\details{
This helper function assigns a
\href{https://www.rfc-editor.org/rfc/rfc9562.html}{UUID} for identifying versions
of generated themes.
}
\examples{
# Random
generate_uuid()

generate_uuid()

# Persistent with hint param

hint <- "something as seed"

generate_uuid(hint)

generate_uuid(hint)

}
\references{
Davis KR, Peabody B, Leach P (2024). "Universally Unique
IDentifiers (UUIDs)." RFC 9562. \doi{10.17487/RFC9562},
\url{https://www.rfc-editor.org/info/rfc9562}.
}
\seealso{
Other helpers: 
\code{\link{on_rstudio}()}
}
\concept{helpers}
