% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read-tm-theme.R
\name{read_tm_theme}
\alias{read_tm_theme}
\title{Read and parse a TextMate theme}
\usage{
read_tm_theme(path)
}
\arguments{
\item{path}{Path or URL to a TextMate theme, in \code{.tmTheme} format.}
}
\value{
A \link[tibble:tbl_df-class]{tibble} with the data of the theme.
}
\description{
Read a \code{.tmTheme} file (XML format) representing a TextMate or Sublime Text
theme.
}
\examples{

the_theme <- system.file("ext/test-color-theme.json",
  package = "rstudiothemes"
) |>
  # Convert the Visual Studio Code theme to TextMate format
  convert_vs_to_tm_theme()

# Check
readLines(the_theme) |>
  head(10) |>
  cat(sep = "\n")

read_tm_theme(the_theme)
}
\seealso{
Other functions for reading themes: 
\code{\link{read_vs_theme}()}
}
\concept{functions for reading themes}
