% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rstudiothemes-actions.R
\name{rstudiothemes-actions}
\alias{rstudiothemes-actions}
\alias{install_rstudiothemes}
\alias{remove_rstudiothemes}
\alias{list_rstudiothemes}
\alias{try_rstudiothemes}
\title{Install, list, try or remove RStudio themes}
\usage{
install_rstudiothemes(
  style = c("all", "dark", "light"),
  themes = NULL,
  destdir = NULL
)

remove_rstudiothemes(style = c("all", "dark", "light"))

list_rstudiothemes(style = c("all", "dark", "light"), list_installed = TRUE)

try_rstudiothemes(style = c("all", "dark", "light"), themes = NULL, delay = 0)
}
\arguments{
\item{style}{Character. Limit themes to a specific group: \code{all}, \code{dark}, or
\code{light}.}

\item{themes}{Optional character vector of theme names. If provided, only
these themes will be used, and \code{style} will be ignored.}

\item{destdir}{Optional directory for \code{.rstheme} files. By default uses
\code{\link[rstudioapi:addTheme]{rstudioapi::addTheme()}}, but this argument allows installation to
non-standard directories.}

\item{list_installed}{Should the installed \pkg{rstudiothemes} themes be
listed (default). If \code{FALSE}, the available themes in the
\pkg{rstudiothemes} package are listed instead.}

\item{delay}{Number of seconds to wait between themes. Set to 0 to be
prompted to continue after each theme.}
}
\value{
\itemize{
\item \code{install_rstudiothemes()} and \code{remove_rstudiothemes()} return \code{NULL}
invisibly.
}

\itemize{
\item \code{list_rstudiothemes()} returns a character vector of theme names.
}

\itemize{
\item \code{try_rstudiothemes()} has side effects of starting a widget that allows
users to try different themes. The widget can be exited by following the
prompts, which will restore the original theme.
}
}
\description{
Adaptation of some \pkg{rsthemes} functions,
\href{https://github.com/gadenbuie/rsthemes/blob/main/LICENSE.md}{MIT License} Copyright © rsthemes authors.

\strong{Important}: These functions (except
\code{list_rstudiothemes(list_installed = FALSE)}) only work in RStudio; they
return \code{NULL} when called from other IDEs.
}
\section{Functions}{
\itemize{
\item \code{install_rstudiothemes()}: Install RStudio themes

\item \code{remove_rstudiothemes()}: Remove \pkg{rstudiothemes} from RStudio

\item \code{list_rstudiothemes()}: List installed or available themes

\item \code{try_rstudiothemes()}: Try each \pkg{rstudiothemes} RStudio theme

}}
\section{Ported Themes}{

\pkg{rstudiothemes} includes RStudio themes based on the
following Visual Studio Code themes:
\itemize{
\item Ayu by teabyii.
\item Andromeda by Eliver Lara.
\item Catppuccin by \url{https://catppuccin.com/}.
\item Cobalt2 Theme Official by Wes Bos.
\item CRAN by dieghernan, based on the CRAN (R Project) website theme, created
with Pandoc
\item Dracula Official by \url{https://draculatheme.com/}.
\item GitHub Dark and Light by GitHub.
\item JellyFish Theme by Pawel Borkar.
\item Matcha by Luca Falasco.
\item Matrix Theme by UstymUkhman.
\item Night Owl Dark and Light (no italics) by Sarah Drasner.
\item Nord by Arctic Ice Studio.
\item OKSolar Theme by dieghernan.
\item One Dark Pro by binaryify.
\item Overflow Theme by dieghernan.
\item Panda Theme by Panda Theme.
\item Selenized Themes by dieghernan.
\item Skeletor Syntax by dieghernan.
\item SynthWave '84 by Robb Owen.
\item Tokyo Night by Enkia.
\item Winter is Coming Theme by John Papa.
}
}

\examples{
list_rstudiothemes(list_installed = FALSE)
}
\references{
Aden-Buie G (2026). \emph{rsthemes: Full Themes for RStudio v1.2+}. R package
version 0.5.1, commit 48fc078f772e5e63669bc9773eabc8e9cdc7f699,
\url{https://github.com/gadenbuie/rsthemes}.
}
\author{
Garrick Aden-Buie \url{https://github.com/gadenbuie}
}
