% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_token_count.R
\name{get_token_count}
\alias{get_token_count}
\title{Returns the number of tokens in a text}
\usage{
get_token_count(text, model)
}
\arguments{
\item{text}{a character string to encode to tokens, can be a vector}

\item{model}{a model to use for tokenization, either a model name, e.g., \verb{gpt-4o}
or a tokenizer, e.g., \code{o200k_base}.
See also \href{https://github.com/zurawiki/tiktoken-rs/blob/main/tiktoken-rs/src/tokenizer.rs}{available tokenizers}.}
}
\value{
the number of tokens in the text, vector of integers
}
\description{
Returns the number of tokens in a text
}
\examples{
get_token_count("Hello World", "gpt-4o")
}
\seealso{
\code{\link[=model_to_tokenizer]{model_to_tokenizer()}}, \code{\link[=get_tokens]{get_tokens()}}
}
