% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rtmsBrukerMCFReader.R
\name{getBrukerMCFIntensities}
\alias{getBrukerMCFIntensities}
\title{Retrieve peak intensities directly from an MCF file}
\usage{
getBrukerMCFIntensities(reader, peaks, indices)
}
\arguments{
\item{reader}{An RTMS reader object of class \code{rtmsBrukerMCFReader}}

\item{peaks}{A list of peak objects of class \code{rtmsPeak}}

\item{indices}{A vector of numeric indices specifying which acquisitions
the measurements should be taken from}
}
\value{
A data frame containing columns specifying the index of each
acquisition, the name of each acquistion (if \code{indices} is a named vector),
the peak value of the peak measure, the peak name (if \code{peaks} is a named
list), the measure name (which will always be "PeakIntensity"), and the
measured value for that sample and peak. Format matches the output of
\code{measureSampleSet}
}
\description{
The size of mass spectrometric data in general, and Bruker MCF directories
specifically, makes the extraction of data a resource intensive and time
consuming process. \code{rtms} as a package is designed to reduce this burden,
but pulling a sample set from an MCF file can (in the event of compressed
spectra) requires reading nearly all data out of a file, which could take an
extremely long time over a network connection.  Since peak intensity
(calculated as the sum of local intensity maxima within a given peak width)
is one of the most common measurements used in evaluating spectra, and
because this measure can be extracted without extracting the full spectra,
this function aims to avoid expensive reading time by skipping the creation
of a sample set object and calculating peak intensity directly.  Other
measurements are not possible, but full spectra do not have to be read, even
when spectra are compressed, as local maxima are pre-processed and stored
separately in a Bruker MCF file.
}
