% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reminders.R
\name{add_reminder}
\alias{add_reminder}
\title{Add a reminder to a task}
\usage{
add_reminder(
  task_id,
  due_date = NULL,
  due_datetime = NULL,
  minute_offset = NULL,
  type = "absolute",
  verbose = TRUE,
  token = get_todoist_api_token()
)
}
\arguments{
\item{task_id}{id of the task}

\item{due_date}{due date for the reminder (format: YYYY-MM-DD)}

\item{due_datetime}{due datetime for the reminder (format: YYYY-MM-DDTHH:MM:SS)}

\item{minute_offset}{minutes before due time to remind (for relative reminders)}

\item{type}{type of reminder: "absolute", "relative", or "location"}

\item{verbose}{boolean that make the function verbose}

\item{token}{todoist API token}
}
\value{
id of the new reminder
}
\description{
Add a reminder to a task
}
\examples{
\dontrun{
add_reminder(task_id = "12345", due_datetime = "2024-12-25T09:00:00")
add_reminder(task_id = "12345", minute_offset = 30, type = "relative")
}
}
