% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trim_smooth.R
\name{plot.trim.smooth}
\alias{plot.trim.smooth}
\title{Plot overall slope}
\usage{
\method{plot}{trim.smooth}(x, imputed = TRUE, ...)
}
\arguments{
\item{x}{An object of class \code{trim.overall} (returned by \code{\link{overall}})}

\item{imputed}{\code{[logical]} Toggle to show imputed counts}

\item{...}{Further options passed to \code{\link[graphics]{plot}}}
}
\description{
Creates a plot of the overall slope, its 95\% confidence band, the
total population per time and their 95\% confidence intervals.
}
\examples{
data(skylark)
m <- trim(count ~ site + time, data=skylark, model=2)
plot(overall(m))

}
\seealso{
Other analyses: 
\code{\link{coef.trim}()},
\code{\link{confint.trim}()},
\code{\link{gof}()},
\code{\link{index}()},
\code{\link{now_what}()},
\code{\link{overall}()},
\code{\link{overdispersion}()},
\code{\link{plot.trim.index}()},
\code{\link{plot.trim.overall}()},
\code{\link{results}()},
\code{\link{serial_correlation}()},
\code{\link{summary.trim}()},
\code{\link{totals}()},
\code{\link{trendlines}()},
\code{\link{trim}()},
\code{\link{vcov.trim}()},
\code{\link{wald}()}
}
\concept{analyses}
