% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_data.R
\name{load_team_staff}
\alias{load_team_staff}
\title{Load cleaned team staff data from the volleydata repository.}
\usage{
load_team_staff(league = NULL, seasons = NULL)
}
\arguments{
\item{league}{A string specifying which of "mlv", "lovb", or "au" to load data for.}

\item{seasons}{An integer or vector of integers of seasons to fetch data for. Defaults to all available seasons.}
}
\value{
A data frame containing the team staff data for the specified seasons.\tabular{ll}{
   Column Name \tab Type \cr
   match_id \tab dbl \cr
   season \tab dbl \cr
   match_datetime \tab chr \cr
   team_name \tab chr \cr
   staff_type \tab chr \cr
   full_name \tab chr \cr
   first_name \tab chr \cr
   last_name \tab chr \cr
   league \tab chr \cr
}
}
\description{
Load cleaned team staff data from the volleydata repository.
}
\examples{
try({load_team_staff("mlv", 2024)})
}
