% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrapEB.R
\name{bootstrapEB}
\alias{bootstrapEB}
\title{Small Area Estimation method with Empirical Bayes and its RRMSE value by Bootstrap Method}
\usage{
bootstrapEB(data, method, opt, seed = NA, maxiter = 25, tol = 1e-05, B = 50)
}
\arguments{
\item{data}{the data must contain two or three columns : code, y, and weight data if exist.}

\item{method}{Method to estimate alpha and beta parameter according to person(rao or claire)}

\item{opt}{Method to estimate alpha and beta parameter according to the way of calculation (moment or nr)}

\item{seed}{Setting a seed in set.seed() function to initialize a pseudorandom number generator with default number 0}

\item{maxiter}{the Maximum iteration value with default 100}

\item{tol}{Tolerance error value at iteration with default 0.00001}

\item{B}{The number of iteration of bootstrap resampling with default 200}
}
\value{
This function returns a list with following objects :
\item{finalres}{an information about direct estimator and EB estimator in each area with its RRMSE value obtained by bootstrap method}
\item{eb.estimation}{an information about EB estimator in each area with its RRMSE value obtained by Naive method}
}
\description{
Small Area Estimation method with Empirical Bayes and its RRMSE value by Bootstrap Method
}
\examples{
## load dataset with no weight value
data(dataEB)
## Calculates EB estimator with its
## RRMSE value by Bootstrap method.
## Its alpha and beta estimator obtained
## by Moment method by J.N.K.Rao
bootstrapEB(data = dataEB[,-c(3)], method = "rao",
 opt = "moment", maxiter = 20, tol = 1e-5,B=20,seed=0)

##load dataset with weight value
data(dataEB)
## Calculates EB estimator with its
## RRMSE value by Bootstrap method.
## Its alpha and beta estimator obtained
## by Moment method by Claire E.B.O.
bootstrapEB(data = dataEB, method = "rao",
 opt = "moment", maxiter = 20, tol = 1e-5,B=20,seed=0)

}
\references{
Rao J, Peralta IM (2015). \emph{Small Area Estimation Second Edition}. John Wiley & Sons, Inc.,Hoboken,
New Jersey, Canada. ISBN 978-1-118-73578-7.
}
