% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/func_simulations.R
\name{simulate.SaemixObject}
\alias{simulate.SaemixObject}
\alias{simul.saemix}
\alias{simulateContinuousSaemix}
\alias{simulateIndividualParameters}
\title{Perform simulations under the model for an saemixObject object}
\usage{
\method{simulate}{SaemixObject}(
  object,
  nsim,
  seed,
  predictions,
  outcome = "continuous",
  res.var = TRUE,
  uncertainty = FALSE,
  ...
)
}
\arguments{
\item{object}{an saemixObject object returned by the \code{\link{saemix}} function}

\item{nsim}{Number of simulations to perform. Defaults to the nb.sim
element in options}

\item{seed}{if non-null, seed used to initiate the random number generator (defaults to NULL)}

\item{predictions}{Whether the simulated parameters should be used to compute predictions.
Defaults to TRUE for continuous data, and to FALSE for non-Gaussian data models.
If FALSE, only individual parameters are simulated.}

\item{outcome}{the type of outcome (used to specify TTE or RTTE models)}

\item{res.var}{Whether residual variability should be added to the
predictions. Defaults to TRUE}

\item{uncertainty}{Uses uncertainty (currently not implemented). Defaults to FALSE}

\item{\dots}{additional arguments, unused (included for compatibility with the generic)}
}
\description{
This function is used to simulate data under the empirical design,
using the model and estimated parameters from a fit.
}
\details{
The simulated data can then be used to produce Visual Predictive Check graphs, as well as
to compute the normalised prediction distribution errors (npde).

This function replaces the previous function (simul.saemix), which will be deprecated in future versions
but can still be called as previously for compatibility purposes.
}
\references{
Brendel, K, Comets, E, Laffont, C, Laveille, C, Mentre, F.
Metrics for external model evaluation with an application to the population
pharmacokinetics of gliclazide, Pharmaceutical Research 23 (2006),
2036-2049.

Holford, N. The Visual Predictive Check: superiority to standard diagnostic
(Rorschach) plots (Abstract 738), in: 14th Meeting of the Population
Approach Group in Europe, Pamplona, Spain, 2005.
}
\seealso{
\code{\link{SaemixObject}},\code{\link{saemix}},
\code{\link{saemix.plot.data}}, \code{\link{saemix.plot.convergence}},
\code{\link{saemix.plot.llis}}, \code{\link{saemix.plot.randeff}},
\code{\link{saemix.plot.obsvspred}}, \code{\link{saemix.plot.fits}},
\code{\link{saemix.plot.parcov}}, \code{\link{saemix.plot.distpsi}},
\code{\link{saemix.plot.scatterresiduals}}, \code{\link{saemix.plot.vpc}}
}
\author{
Emmanuelle Comets \href{mailto:emmanuelle.comets@inserm.fr}{emmanuelle.comets@inserm.fr}, Audrey Lavenu,
Marc Lavielle.
}
\keyword{model}
