% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-query.R
\name{extract_records_from_xml_node}
\alias{extract_records_from_xml_node}
\title{Pulls out a tibble of record info from an XML node}
\usage{
extract_records_from_xml_node(
  node,
  object_name_append = FALSE,
  object_name_as_col = FALSE
)
}
\arguments{
\item{node}{\code{xml_node}; the node to have records extracted into one row \code{tbl_df}.}

\item{object_name_append}{\code{logical}; whether to include the object type
(e.g. Account or Contact) as part of the column names (e.g. Account.Name).}

\item{object_name_as_col}{\code{logical}; whether to include the object type
(e.g. Account or Contact) as a new column.}
}
\value{
\code{tbl_df} parsed from the supplied node
}
\description{
This function accepts an \code{xml_node} assuming it already represents one
record and formats that node into a single row \code{tbl_df}.
}
\note{
This function is meant to be used internally. Only use when debugging.
}
\keyword{internal}
