% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-report.R
\name{format_report_row}
\alias{format_report_row}
\title{Format a single "rows" element from a report fact map}
\usage{
format_report_row(
  x,
  labels = TRUE,
  guess_types = TRUE,
  bind_using_character_cols = deprecated()
)
}
\arguments{
\item{x}{\code{list}; a single element from the \code{rows} element of a fact
map. When the data is in a tabular format, this element usually has the same
length as the number of columns with each element having a label and value
element.}

\item{labels}{\code{logical}; an indicator of whether the returned data should
be the label (i.e. formatted value) or the actual value. By default, the labels
are returned because these are what appear in the Salesforce dashboard and
more closely align with the column names. For example, "Account.Name" label
may be \code{"Account B"} and the value \code{0016A0000035mJEQAY}. The former
(label) more accurately reflects the "Account.Name".}

\item{guess_types}{\code{logical}; indicating whether or not to use \code{col_guess()}
to try and cast the data returned in the recordset. If \code{TRUE} then
\code{col_guess()} is used along with \code{anytime()} and \code{anydate()}.
If \code{FALSE} then all fields will be returned as character. Specifying
\code{FALSE} helpful when guessing the column data type will result in NA
values and you would like to return the results as strings and then cast in
your script according to your unique specifications.}

\item{bind_using_character_cols}{\code{logical}; an indicator of whether to
cast the data to all character columns to ensure that \code{\link[dplyr:bind]{bind_rows}}
does not fail because two paginated recordsets have differing datatypes for the
same column. Set this to \code{TRUE} rarely, typically only when having this
set to \code{FALSE} returns an error or you want all columns in the data to be
character.}
}
\value{
\code{tbl_df}; a single row data frame with the data for the row that
the supplied list represented in the report's fact map.
}
\description{
This function accepts a list representing a single row from a report and
selects either the value or label for the report columns to turn into a one
row \code{tbl_df} that will usually be bound to the other rows in the report
}
\note{
This function is meant to be used internally. Only use when debugging.
}
\keyword{internal}
