% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analytics-report.R
\name{sf_delete_report}
\alias{sf_delete_report}
\title{Delete a report}
\usage{
sf_delete_report(report_id, verbose = FALSE)
}
\arguments{
\item{report_id}{\code{character}; the Salesforce Id assigned to a created
analytics report. It will start with \code{"00O"}.}

\item{verbose}{\code{logical}; an indicator of whether to print additional
detail for each API call, which is useful for debugging. More specifically, when
set to \code{TRUE} the URL, header, and body will be printed for each request,
along with additional diagnostic information where available.}
}
\value{
\code{logical} indicating whether the report was deleted. This function
will return \code{TRUE} if successful in deleting the report.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Delete a report by sending a DELETE request to the Report resource. Deleted
reports are moved to the Recycle Bin.
}
\section{Salesforce Documentation}{

\itemize{
\item \href{https://developer.salesforce.com/docs/atlas.en-us.api_analytics.meta/api_analytics/sforce_analytics_rest_api_delete_report.htm#example_delete_report}{Documentation}
}
}

\examples{
\dontrun{
# first, grab all possible reports in your Org
all_reports <- sf_query("SELECT Id, Name FROM Report")

# second, get the id of the report to delete
this_report_id <- all_reports$Id[1]

# third, delete that report using its Id
success <- sf_delete_report(this_report_id)
}
}
\seealso{
Other Report functions: 
\code{\link{sf_copy_report}()},
\code{\link{sf_create_report}()},
\code{\link{sf_describe_report}()},
\code{\link{sf_describe_report_type}()},
\code{\link{sf_execute_report}()},
\code{\link{sf_list_report_fields}()},
\code{\link{sf_list_report_filter_operators}()},
\code{\link{sf_list_report_types}()},
\code{\link{sf_list_reports}()},
\code{\link{sf_query_report}()},
\code{\link{sf_run_report}()},
\code{\link{sf_update_report}()}
}
\concept{Report functions}
