% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accessdb.R
\name{sm_data}
\alias{sm_data}
\title{Retrieve Data from the Database}
\usage{
sm_data(
  dsid = NULL,
  series = NULL,
  from = NULL,
  to = NULL,
  freq = NULL,
  labels = TRUE,
  wide = TRUE,
  expand.date = FALSE,
  ordered = TRUE,
  return.query = FALSE,
  ...
)
}
\arguments{
\item{dsid}{character. (Optional) id's of datasets matching the 'dsid' column of the 'DATASET' table (retrieved using \code{\link[=sm_datasets]{sm_datasets()}}). If used, all series from the dataset are returned, in addition to any other series selected with \code{series}.}

\item{series}{character. (Optional) codes of series matching the 'series' column of the 'SERIES' table (retrieved using \code{\link[=sm_series]{sm_series()}}). If 'dsid' is also specificed, the two are combined using SQL 'OR' i.e. these series are retrieved in addition to all series matched through 'dsid'.}

\item{from}{set the start time of the data retrieved by either supplying a start date, a date-string of the form \code{"YYYY-MM-DD"} or \code{"YYYY-MM"},
year-quarters of the form \code{"YYYYQN"} or \code{"YYYY-QN"}, or a numeric year \code{YYYY} (numeric or character). These expressions are converted to a regular date by \code{\link{sm_as_date}}.}

\item{to}{same as \code{from}: to set the time period until which data is retrieved. For expressions that are not full "YYYY-MM-DD" dates, the last day of the period is chosen.}

\item{freq}{character. Return only series at a certain frequency. Allowed are values \code{"D"} (Daily), \code{"W"} (Weekly), \code{"M"} (Monthly), \code{"Q"} (Quarterly), \code{"A"} (Annual), \code{"AF"} (Fiscal Years), matching the 'freq' column in the 'SERIES' table (retrieved using \code{\link[=sm_series]{sm_series()}}).}

\item{labels}{logical. \code{TRUE} will also return labels (series descriptions) along with the series codes.}

\item{wide}{logical. \code{TRUE} calls \code{\link{sm_pivot_wider}} on the result. \code{FALSE} returns the data in a long format without missing values (suitable for \code{ggplot2}).}

\item{expand.date}{logical. \code{TRUE} will call \code{\link{sm_expand_date}} on the result.}

\item{ordered}{logical. \code{TRUE} orders the result by 'date' and, if \code{!is.null(dsid)}, \code{labels = TRUE} or \code{!is.null(freq)}, by series, maintaining a fixed order of series.
\code{FALSE} does not explicitly order the result, to the benefit of faster query execution.}

\item{return.query}{logical. \code{TRUE} will not query the database but instead return the constructed SQL query as a character string (for debugging purposes).}

\item{\dots}{further arguments passed to \code{\link{sm_pivot_wider}} (if \code{wide = TRUE}) or \code{\link{sm_expand_date}} (if \code{expand.date = TRUE}), no conflicts between these two.}
}
\value{
A \code{\link[data.table]{data.table}} with the result of the query.
}
\description{
This is the main function of the package to retrieve data from the database.
}
\details{
Series from datasets at different frequencies can be queried, but, if \code{wide = TRUE}, this will result in missing values in the lower frequency series.
}
\examples{
\donttest{
# Return all electricity indicators from 2000
sm_data("ELECTRICITY", from = 2000)

}
}
\seealso{
\code{\link{sm_pivot_wider}}, \code{\link{sm_expand_date}}, \code{\link{samadb}}
}
