% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.sampbias.R
\name{plot.sampbias}
\alias{plot.sampbias}
\title{Plotting the Posterior Estimates of the Bias Weights}
\usage{
\method{plot}{sampbias}(x, ...)
}
\arguments{
\item{x}{an object of the class \code{sampbias}.}

\item{\dots}{Additional arguments passed to summary.}
}
\value{
A plot
}
\description{
Plotting method for class \code{sampbias}, generating a box-whiskers-plot
showing the bias weights for all biasing factors
indicating the effect strength for each gazetteer provided to
\code{calculate_bias}.
}
\examples{
\donttest{
  #simulate data
  occ <- data.frame(species = rep(sample(x = LETTERS, size = 5), times = 10),
                   decimalLongitude = runif(n = 50, min = 12, max = 20),
                   decimalLatitude = runif(n = 50, min = -4, max = 4))

  out <- calculate_bias(x = occ, terrestrial = TRUE)
  summary(out)
  plot(out)
}

}
\seealso{
\code{\link{calculate_bias}}, \code{\link{summary.sampbias}}
}
\keyword{methods}
