% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/santoku-package.R
\docType{package}
\name{santoku-package}
\alias{santoku}
\alias{santoku-package}
\title{A versatile cutting tool for R: package overview and options}
\description{
santoku is a tool for cutting data into intervals. It provides
the function \code{\link[=chop]{chop()}}, which is similar to base R's \code{\link[=cut]{cut()}} or \code{Hmisc::cut2()}.
\code{chop(x, breaks)} takes a vector \code{x} and returns a factor of the
same length, coding which interval each element of \code{x} falls into.
}
\details{
Here are some advantages of santoku:
\itemize{
\item By default, \code{chop()} always covers the whole range of the data, so you
won't get unexpected \code{NA} values.
\item Unlike \code{cut()} or \code{cut2()}, \code{chop()} can handle single values as well as
intervals. For example, \code{chop(x, breaks = c(1, 2, 2, 3))} will create a
separate factor level for values exactly equal to 2.
\item Flexible and easy labelling.
\item Convenience functions for creating quantile intervals, evenly-spaced
intervals or equal-sized groups.
\item Convenience functions to quickly tabulate chopped data.
\item Can chop numbers, dates, date-times and other objects.
}

These advantages make santoku especially useful for exploratory analysis,
where you may not know the range of your data in advance.

To get started, read the vignette:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{vignette("santoku")
}\if{html}{\out{</div>}}

For more details, start with the documentation for \code{\link[=chop]{chop()}}.
}
\section{Options}{
Santoku has two options:
\itemize{
\item \code{options("santoku.infinity")} sets the symbol for infinity in breaks. The default is
\code{NULL}, in which case the infinity symbol is used on platforms that support it, otherwise
\code{"Inf"} is used.
\item \code{options("santoku.warn_character")} warns if you try to chop a character vector. Set to
\code{FALSE} to turn off this warning.
}
}

\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/hughjonesd/santoku}
  \item \url{https://hughjonesd.github.io/santoku/}
  \item Report bugs at \url{https://github.com/hughjonesd/santoku/issues}
}

}
\author{
\strong{Maintainer}: David Hugh-Jones \email{davidhughjones@gmail.com}

Other contributors:
\itemize{
  \item Daniel Possenriede \email{possenriede@gmail.com} [contributor]
}

}
