% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getters.R
\name{filter_sites_by_md}
\alias{filter_sites_by_md}
\title{Filter the sites by metadata variable values}
\usage{
filter_sites_by_md(sites, metadata, ..., .join = c("and", "or"))
}
\arguments{
\item{sites}{character vector with the sites codes to filter, generally the
result of \code{\link{sfn_sites_in_folder}}}

\item{metadata}{metadata tbl object, usually the result of
\code{\link{read_sfn_metadata}}}

\item{...}{Logical expressions for the metadata variables, as in
\code{\link[dplyr]{filter}}.}

\item{.join}{Character indicating how to filter the sites, see details.}
}
\value{
A character vector with the sites fulfilling the premises
}
\description{
\code{filter_sites_by_md} function takes logical expressions for the metadata
variables (i.e. \code{pl_sens_meth == 'HR'}), and list the sites that met
the criteria from those supplied
}
\details{
\code{.join} argument indicates how sites must be filtered between metadata
classes. \code{'and'} indicates only sites meeting all conditions for all
metadata classes are returned. \code{'or'} indicates all sites meeting any
condition between classes are returned. For two or more filters of the same
metadata class, they are combined as 'and'.
}
\examples{
# Let's access the data in "folder". This typically is the folder where the
# sapflow data at the desired unit level is (i.e. "RData/plant"), but in this
# example we will create a temporal folder with some data to test the function
folder <- tempdir()
save(ARG_TRE, file = file.path(folder, 'ARG_TRE.RData'))
save(ARG_MAZ, file = file.path(folder, 'ARG_MAZ.RData'))
save(AUS_CAN_ST2_MIX, file = file.path(folder, 'AUS_CAN_ST2_MIX.RData'))

# we need the metadata and the site names
metadata <- read_sfn_metadata(folder = folder, .write_cache = TRUE)
sites <- sfn_sites_in_folder(folder)

# Filter by Heat Ratio method
filter_sites_by_md(
  pl_sens_meth == 'HR', sites = sites, metadata = metadata
)

# Both, Heat Ratio and Heat Dissipation
filter_sites_by_md(
  pl_sens_meth \%in\% c('HR', 'HD'),
  sites = sites, metadata = metadata
)

# more complex, Heat Ratio method AND Woodland/Shrubland biome
filter_sites_by_md(
  pl_sens_meth == 'HR',
  si_biome == 'Woodland/Shrubland',
  sites = sites, metadata = metadata,
  .join = 'and' # default
)

# join = 'or' returns sites that meet any condition
filter_sites_by_md(
  pl_sens_meth == 'HR',
  si_biome == 'Woodland/Shrubland',
  sites = sites, metadata = metadata,
  .join = 'or'
)

}
