% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getters.R
\name{read_sfn_data}
\alias{read_sfn_data}
\title{Read sfn_data from disk}
\usage{
read_sfn_data(site_codes, folder = ".")
}
\arguments{
\item{site_codes}{A character vector with the site code/s}

\item{folder}{Route to the folder containing the \code{.RData} file. Default
to working directory.}
}
\value{
If \code{site_codes} is a vector of length 1, an sfn_data object with
  the selected site data. If \code{site_codes} is a vector of length > 1, then
  a sfn_data_multi object containing all selected sites.
}
\description{
Given a site code and a route, \code{read_sfn_data} will return the selected
sfn_data object
}
\examples{
# Let's access the data in "folder". This typically is the folder where the
# sapflow data at the desired unit level is (i.e. "RData/plant"), but in this
# example we will create a temporal folder with some data to test the function
folder <- tempdir()
save(ARG_TRE, file = file.path(folder, 'ARG_TRE.RData'))
save(ARG_MAZ, file = file.path(folder, 'ARG_MAZ.RData'))

# now we read a single site
ARG_TRE_test <- read_sfn_data('ARG_TRE', folder)
ARG_TRE_test

# or we can read multiple sites at once
multi_sfn <- read_sfn_data(
  c('ARG_TRE', 'ARG_MAZ'), folder
)
multi_sfn

}
