% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_step.R
\name{data_step}
\alias{data_step}
\title{SAS IF-style data step logic for data.table}
\usage{
data_step(dt, ..., copy = TRUE)
}
\arguments{
\item{dt}{A data.table.}

\item{...}{One or more rule objects created by if_do(), else_if_do(),
else_do(), if_independent(), or delete_if().}

\item{copy}{Logical. If TRUE (default), a copy of dt is modified and returned.}
}
\value{
A data.table with applied transformations.
}
\description{
Provides SAS-style IF/ELSE chains, independent IF rules, and DELETE logic
for fast, vectorized transformations on data.table objects. This enables
clinical programmers to express SDTM and ADaM-style derivations in familiar
SAS-like syntax while leveraging data.table performance.
}
\examples{
library(data.table)

dt <- data.table(
  AGE = c(40, 60, 80),
  SEX = c("M", "F", "M")
)

out <- data_step(
  dt,
  if_do(AGE <= 45, GROUP = 1),
  else_if_do(AGE <= 70, GROUP = 2),
  else_do(GROUP = 3),
  if_independent(SEX == "M", MALE = 1)
)

out

}
