% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_annot_ctgenes.R
\name{f_annot_ctgenes}
\alias{f_annot_ctgenes}
\title{Choose best matching cell type}
\usage{
f_annot_ctgenes(m.cts, unknown, uncertain)
}
\arguments{
\item{m.cts}{Matrix containing the cell type scores. The rows represent the cell types, whereas the columns represent the samples.}

\item{unknown}{If none of the probabilities is above this threshold,
the cell type label is assigned to the class unknown.}

\item{uncertain}{If the ratio between the largest and the second largest
probability is below this threshold, the cell type label is assigned to the
class uncertain for the major cell types.}
}
\value{
Data frame containing the best matching cell type for each sample.
}
\description{
Choose best matching cell type
}
\examples{
m.cts <- matrix(c(0.2, 0.001, 0.002, 0.1), nrow=2)
colnames(m.cts) <- c("sample1", "sample2")
rownames(m.cts) <- c("cell_type1", "cell_type2")
f_annot_ctgenes(m.cts, 0.05, 0.1)
}
