#'Combine Lists of Draws From a Posterior Predictive Distribution
#'
#' @description
#' \code{combine_draws} combines and resamples parameter draws returned from an MCMC algorithm.
#' 
#' @param draws A list of draws from a posterior predictive distribution
#' @param r Number of MCMC draws
#' 
#' @return A matrix or data frame containing `R` randomly sampled rows 
#'         from the combined `betadraw` components.
#'         
#' @seealso 
#' \code{\link{rhierLinearMixtureParallel}}, 
#' \code{\link{rhierMnlRwMixtureParallel}}, 
#' \code{\link{rhierLinearDPParallel}}, 
#' \code{\link{rhierMnlDPParallel}}
#' 
#' @author Federico Bumbaca, Leeds School of Business, University of Colorado Boulder, \email{federico.bumbaca@colorado.edu}
#' @references Bumbaca, F. (Rico), Misra, S., & Rossi, P. E. (2020). Scalable Target Marketing: Distributed Markov Chain Monte Carlo for Bayesian Hierarchical Models. Journal of Marketing Research, 57(6), 999-1018.
#' 
#' 
#'
#' @export
combine_draws = function(draws, r) {
  draws = do.call("rbind", lapply(draws, function(x) x$betadraw))
  ndraws = nrow(draws)
  draws = draws[sample.int(ndraws, r, replace = FALSE),]
  return(draws)
}