% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/action.R
\name{construct_action}
\alias{construct_action}
\title{Construct a Scene Action}
\usage{
construct_action(fn, ..., negate = FALSE, methods = "GET")
}
\arguments{
\item{fn}{A function that takes a request (and potentially other arguments)
and returns \code{TRUE} or \code{FALSE}.}

\item{...}{Additional parameters passed on to \code{fn}.}

\item{negate}{If \code{TRUE}, trigger the corresponding scene when this action is
\code{not} matched.}

\item{methods}{The http methods which needs to be accepted in order for this
function to make sense. Default "GET" should work in almost all cases.}
}
\value{
A \code{scene_action} object.
}
\description{
Generate the check function for an action, and use it to create a
\code{scene_action} object.
}
\examples{
simple_function <- function(request) {
  !missing(request) && length(request) > 0
}
sample_action <- construct_action(simple_function)
sample_action$check_fn()
sample_action$check_fn(list())
sample_action$check_fn(list(a = 1))
}
