% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/account.R
\name{schwab_act_hash}
\alias{schwab_act_hash}
\title{Get account hashed value}
\usage{
schwab_act_hash(account_number = "", accessTokenList = NULL)
}
\arguments{
\item{account_number}{A Standard Schwab Account number}

\item{accessTokenList}{A valid Access Token must be set using
\code{\link{schwab_auth3_accessToken}}. The most recent Access Token will be
used by default unless one is manually passed into the function.}
}
\value{
A hashed account number
}
\description{
Retrieves the Hashed account value for a specific account
}
\examples{
\dontrun{

# Get stored refresh token
refreshToken = readRDS('/secure/location/')

# Generate a new access token
accessTokenList = schwab_auth3_accessToken(appKey, appSecret, refreshToken)

# Passing the accessTokenList is optional. The default will return balances
act_hash = schwab_act_hash(account_number = '123456789')


}
}
