% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scorecard.R
\name{scorecard_ply}
\alias{scorecard_ply}
\title{Score Transformation}
\usage{
scorecard_ply(dt, card, only_total_score = TRUE, print_step = 0L,
  replace_blank_na = TRUE, var_kp = NULL)
}
\arguments{
\item{dt}{A data frame, which is the original dataset for training model.}

\item{card}{A data frame or a list of data frames. It's the scorecard generated from the function \code{scorecard}.}

\item{only_total_score}{Logical, Defaults to TRUE. If it is TRUE, then the output includes only total credit score; Otherwise, if it is FALSE, the output includes both total and each variable's credit score.}

\item{print_step}{A non-negative integer. Defaults to 1. If print_step>0, print variable names by each print_step-th iteration. If print_step=0, no message is print.}

\item{replace_blank_na}{Logical. Replace blank values with NA. Defaults to TRUE. This argument should be the same with \code{woebin}'s.}

\item{var_kp}{Name of force kept variables, such as id column. Defaults to NULL.}
}
\value{
A data frame in score values
}
\description{
\code{scorecard_ply} calculates credit score using the results from \code{scorecard}.
}
\examples{
\donttest{
# load germancredit data
data("germancredit")
# filter variable via missing rate, iv, identical value rate
dtvf = var_filter(germancredit, "creditability")
# split into train and test
dtlst = split_df(dtvf, y = 'creditability')
# binning
bins = woebin(dtlst$train, "creditability")
# scorecard
card = scorecard2(bins=bins, dt=dtlst$train, y='creditability')

# credit score
# Example I # only total score
score1 = scorecard_ply(germancredit, card)

# Example II # credit score for both total and each variable
score2 = scorecard_ply(germancredit, card, only_total_score = FALSE)
}
}
\seealso{
\code{\link{scorecard}} \code{\link{scorecard2}}
}
