% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function-factory-helpers.R
\name{absorb_key_args}
\alias{absorb_key_args}
\title{Absorb key arguments from the user's call}
\usage{
absorb_key_args(data, reported, key_cols_call)
}
\arguments{
\item{data}{User-supplied data frame.}

\item{reported}{String. Names of the key arguments.}

\item{key_cols_call}{User-provided arguments named after one or more key
columns.}
}
\value{
Data frame \code{data}, possibly with one or more columns renamed.
Remember reassigning the value to \code{data}!
}
\description{
If \code{insert_key_args()} is called in the exit area of a function factory
(i.e., after the part that produces the factory-made function),
\code{absorb_key_args()} must be called in the main part. Unlike the former, it
transforms \code{data}, not \code{fun}, and should be reassigned to \code{data}.
}
\details{
It renames key columns that have non-standard names, following user-supplied
directions via the arguments automatically inserted below the function.
}
\examples{
# Not really a meaningful example -- need to use
# the function in very specific places
data <- grim_map(pigs1)
data <- absorb_key_args(data, c("x", "n"))
}
