% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/debit-map.R
\name{debit_map}
\alias{debit_map}
\title{Apply DEBIT to many cases}
\usage{
debit_map(
  data,
  x = NULL,
  sd = NULL,
  n = NULL,
  rounding = "up_or_down",
  threshold = 5,
  symmetric = FALSE,
  show_rec = TRUE,
  extra = Inf
)
}
\arguments{
\item{data}{Data frame.}

\item{x, sd, n}{Optionally, specify these arguments as column names in \code{data}.}

\item{rounding, threshold, symmetric}{Arguments passed on to \code{\link[=debit]{debit()}}, with
the same defaults.}

\item{show_rec}{If set to \code{FALSE}, the resulting tibble only includes the
columns \code{x}, \code{sd}, \code{n}, and \code{consistency}. Default is \code{TRUE}.}

\item{extra}{Not currently used.}
}
\value{
A tibble with (at least) these columns --
\itemize{
\item \code{x}, \code{sd}, \code{n}: the inputs.
\item \code{consistency}: DEBIT consistency of \code{x}, \code{sd}, and \code{n}.

By default, the tibble also includes the rounding method, boundary values,
and information about the boundary values being inclusive or not. The
tibble has the \code{scr_debit_map} class, which is recognized by the \code{audit()}
generic.
}
}
\description{
Call \code{debit_map()} to use DEBIT on multiple combinations of
mean, sample standard deviation, and sample size of binary distributions.
Mapping function for \code{\link[=debit]{debit()}}.

For summary statistics, call \code{\link[=audit]{audit()}} on the results.
}
\section{Summaries with \code{\link[=audit]{audit()}}}{
 There is an S3 method for the
\code{\link[=audit]{audit()}} generic, so you can call \code{\link[=audit]{audit()}} following \code{debit_map()}.
It returns a tibble with these columns ---
\enumerate{
\item \code{incons_cases}: the number of DEBIT-inconsistent cases.
\item \code{all_cases}: the total number of cases.
\item \code{incons_rate}: the rate of inconsistent cases.
\item \code{mean_x}: the mean \code{x} (mean) value.
\item \code{mean_sd}: the mean \code{sd} value.
\item \code{distinct_n}: the number of distinct \code{n} values.
}
}

\examples{
# Call `debit_map()` on binary summary
# data such as these:
pigs3

# The `consistency` column shows
# whether the values to its left
# are DEBIT-consistent:
pigs3 \%>\%
  debit_map()

# Get test summaries with `audit()`:
pigs3 \%>\%
  debit_map() \%>\%
  audit()
}
\references{
Heathers, James A. J., and Brown, Nicholas J. L. 2019. DEBIT: A
Simple Consistency Test For Binary Data. https://osf.io/5vb3u/.
}
