# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Hash a password
#'
#' @param passwd password to hash
#' @param maxmem max memory percent (default 0.1)
#' @param maxtime max cpu time (default 1.0)
#' @return base64 encoded hash
#' @examples
#'
#' # Hash password using default parameters
#' hashPassword('passw0rd')
#'
#' # Hash password with custom parameters
#' hashPassword('passw0rd', maxmem=0.25, maxtime=1.0)
#'
#' @seealso \code{\link{verifyPassword}}
#' @export
hashPassword <- function(passwd, maxmem = 0.1, maxtime = 1.0) {
    .Call(`_scrypt_hashPassword`, passwd, maxmem, maxtime)
}

#' Verify a hashed password
#'
#' @param hash base64 hash to verify
#' @param passwd password to verify
#' @return
#' TRUE if password matches hash, otherwise FALSE
#' @examples
#' # Hash password using default parameters
#' hashed <- hashPassword("password")
#'
#' # verify invalid password
#' verifyPassword(hashed, "bad password");
#'
#' # verify correct password
#' verifyPassword(hashed, "password")
#'
#' @seealso {
#' \code{\link{hashPassword}}
#' }
#' @export
verifyPassword <- function(hash, passwd) {
    .Call(`_scrypt_verifyPassword`, hash, passwd)
}

#' @importFrom Rcpp evalCpp
#' @useDynLib scrypt
#' @export
scrypt <- function(passwd, salt, n, r, p, length = 64L) {
    .Call(`_scrypt_scrypt`, passwd, salt, n, r, p, length)
}

