% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/custom_func.R
\name{pulse}
\alias{pulse}
\title{Create pulse function}
\usage{
pulse(times, start, height = 1, width = 1, repeat_interval = NULL)
}
\arguments{
\item{times}{Vector of simulation times}

\item{start}{Start time of pulse in simulation time units.}

\item{height}{Height of pulse. Defaults to 1.}

\item{width}{Width of pulse in simulation time units. This cannot be equal to or less than 0. To indicate an instantaneous pulse, specify the simulation step size.}

\item{repeat_interval}{Interval at which to repeat pulse. Defaults to NULL to indicate no repetition.}
}
\value{
Pulse interpolation function
}
\description{
Create a pulse function that jumps from zero to a specified height at a specified time, and returns to zero after a specified width. The pulse can be repeated at regular intervals.
}
\details{
Equivalent of Pulse() in Insight Maker
}
\examples{
# Create a simple model with a pulse function
# that starts at time 5, jumps to a height of 2
# with a width of 1, and does not repeat
sfm <- xmile() |>
  build("a", "stock") |>
  # Specify the global variable "times" as simulation times
  build("input", "constant", eqn = "pulse(times, 5, 2, 1)") |>
  build("inflow", "flow", eqn = "input(t)", to = "a")

\dontshow{
sfm <- sim_specs(sfm, dt = .1)
}

sim <- simulate(sfm, only_stocks = FALSE)
plot(sim)

# Create a pulse that repeats every 5 time units
sfm <- build(sfm, "input", eqn = "pulse(times, 5, 2, 1, 5)")

sim <- simulate(sfm, only_stocks = FALSE)
plot(sim)

}
\seealso{
\code{\link[=step]{step()}}, \code{\link[=ramp]{ramp()}}, \code{\link[=seasonal]{seasonal()}}
}
\concept{input}
