% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KI_applyAnonymization.R
\name{KI_applyAnonymization}
\alias{KI_applyAnonymization}
\title{KI_applyAnonymization: Automatically apply anonymization strategy using LLM}
\usage{
KI_applyAnonymization(
  sdcObj,
  auto = TRUE,
  generateReport = TRUE,
  k = 3,
  verbose = TRUE,
  model = "gpt-4",
  api_key = Sys.getenv("OPENAI_API_KEY")
)
}
\arguments{
\item{sdcObj}{An object of class sdcMicroObj.}

\item{auto}{If TRUE, automatically applies the suggested strategy.}

\item{generateReport}{If TRUE, generates internal and external reports.}

\item{k}{Desired k-anonymity level.}

\item{verbose}{If TRUE, prints LLM strategy.}

\item{model}{OpenAI model (default: 'gpt-4').}

\item{api_key}{Optional API key. Defaults to Sys.getenv("OPENAI_API_KEY").}
}
\value{
Modified sdcMicroObj with anonymization applied (if auto = TRUE).
}
\description{
Applies an anonymization plan suggested by an LLM based on the structure and risk profile of an sdcMicro object.
}
\examples{
\dontrun{
if (interactive() && nzchar(Sys.getenv("OPENAI_API_KEY"))) {
  library(sdcMicro)
  data(testdata)
  sdc <- KI_createSdcObj(
    dat = testdata,
    policy = "open",
    model = "gpt-4",
    api_key = Sys.getenv("OPENAI_API_KEY")
  )
  sdc <- KI_applyAnonymization(
    sdcObj = sdc,
    k = 3,
    auto = TRUE,
    generateReport = FALSE,
    verbose = TRUE,
    model = "gpt-4",
    api_key = Sys.getenv("OPENAI_API_KEY")
  )
  sdc <- KI_applyAnonymization(
    sdcObj = sdc,
    k = 3,
    auto = TRUE,
    generateReport = FALSE,
    verbose = TRUE,
    model = "gpt-4-turbo",
    api_key = Sys.getenv("OPENAI_API_KEY")
  ) 
}
}
}
\author{
Matthias Templ
}
