% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cal_min_max_date.R
\name{cal_min_max_date}
\alias{cal_min_max_date}
\title{Calculate minimum and maximum date and time in the data frame}
\usage{
cal_min_max_date(
  raw_dataset,
  date_variable,
  time_variable,
  val_type = "min",
  date_format,
  time_format
)
}
\arguments{
\item{raw_dataset}{Raw source data frame}

\item{date_variable}{Single character string. Name of the date variable}

\item{time_variable}{Single character string. Name of the time variable}

\item{val_type}{Single character string determining whether to look
for the earliest or the latest datetime combination. Permitted values:
"min", "max". Default to "min".}

\item{date_format}{Format of source date variable}

\item{time_format}{Format of source time variable}
}
\value{
Data frame with 2 columns: unique patient_number and datetime variable
column storing the earliest/latest datetime.
}
\description{
This function derives the earliest/latest date as ISO8601 datetime
}
\examples{
ex_raw <- tibble::tribble(
  ~patient_number,    ~EX_ST_DT, ~EX_ST_TM,
  "001",           "25-04-2022",   "10:20",
  "001",           "25-04-2022",   "10:15",
  "001",           "25-04-2022",   "10:19",
  "002",           "26-05-2022", "UNK:UNK",
  "002",           "26-05-2022",   "05:59"
)

min <- cal_min_max_date(ex_raw,
  date_variable = "EX_ST_DT",
  time_variable = "EX_ST_TM",
  val_type = "min",
  date_format = "dd-mmm-yyyy",
  time_format = "H:M"
)

max <- cal_min_max_date(ex_raw,
  date_variable = "EX_ST_DT",
  time_variable = "EX_ST_TM",
  val_type = "max",
  date_format = "dd-mmm-yyyy",
  time_format = "H:M"
)

}
