% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ct.R
\name{is_ct_mappable}
\alias{is_ct_mappable}
\title{Identify CT mappable terms}
\usage{
is_ct_mappable(x, from)
}
\arguments{
\item{x}{A character vector of terms to be evaluated for recoding.}

\item{from}{A character vector of controlled terminology terms that \code{x} will
be compared against.}
}
\value{
A logical vector of the same length as \code{x}, where \code{TRUE} indicates the
corresponding term in \code{x} is found in \code{from}, and \code{FALSE} otherwise.
}
\description{
\code{\link[=is_ct_mappable]{is_ct_mappable()}} returns a logical vector indicating whether each element
of \code{x} is found in the \code{from} values used for controlled terminology recoding.

Empty strings (blanks) and \code{NA} values are treated specially and are
considered mappable terms, even though they might not be.

This function is useful for checking in advance which terms in a vector can be
recoded given a specified controlled terminology mapping.
}
\keyword{internal}
