% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/code-to-term.R
\name{term_to_code}
\alias{term_to_code}
\title{SDTM term to code}
\usage{
term_to_code(term, clst_code)
}
\arguments{
\item{term}{A SDTM controlled terminology term (as expected in submissions).}

\item{clst_code}{Parent codelist code.}
}
\value{
A character vector of SDTM controlled terminology C-codes. The number
of elements returned matches the number of elements in \code{term}, i.e. there
is a one-to-one correspondence between input and output. Invalid codes in
\code{term} are mapped to \code{NA}.
}
\description{
\code{\link[=term_to_code]{term_to_code()}} maps SDTM terminology terms to respective C-codes. For
mapping terms referring to codelists, use \code{\link[=clst_term_to_code]{clst_term_to_code()}} instead.
}
\examples{
term_to_code(term = "TENMW101", clst_code = "C141657")

# Both `term` and `clst_code` are vectorized. `clst_code` will be recycled
# to match `term` number of elements.
term_to_code(term = c("TENMW101", "TENMW102"), clst_code = "C141657")

# You may mix codelists as long as `term` and `clst_code` have the same
# number of elements; they will be matched element-wise.
term_to_code(
  term = c("TENMW101", "TENMW102", "TENMW1-Test Grade"),
  clst_code = c("C141657", "C141657", "C141656")
)

# Invalid terms (e.g. `"Gambelas"`) map to `NA`.
term_to_code(term = c("TENMW101", "TENMW102", "Gambelas"), clst_code = "C141657")

}
\seealso{
See \code{\link[=code_to_term]{code_to_term()}} for the inverse operation.
}
