% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_mi_mispec.R
\name{check_mi_mispec}
\alias{check_mi_mispec}
\title{Check for missing values in the MISPEC variable}
\usage{
check_mi_mispec(MI)
}
\arguments{
\item{MI}{Microscopic Findings with variables USUBJID, MISPEC, MITESTCD, MIDTC}
}
\value{
boolean value if check failed or passed with 'msg' attribute if the test failed
}
\description{
This check looks for missing values in the MISPEC variable,
which is required. This will be flagged in P21. This may reflect a mapping issue.
}
\examples{

MI <- data.frame(
  USUBJID = c("1","2", "3"),
  DOMAIN = "MI",
  MISEQ = c(1, 2, 1),
  MISPEC = c("","BLOCK SLIDE",NA),
  MITESTCD = "TESTCD1",
  MIDTC = "2020-01-01",
stringAsFactors = FALSE
)

 check_mi_mispec(MI)

## No errors, MISPEC values present
MI2 <- data.frame(
 USUBJID = c("1","2", "3"),
 DOMAIN = "MI",
 MISEQ = 1,
 MISPEC = c("SLIDE", "TUMOR TISSUE", "BLOCK SLIDE"),
 MITESTCD = "TESTCD1",
 MIDTC = "",
 stringsAsFactors = FALSE
)

 check_mi_mispec(MI2)

}
\author{
Stella Banjo (HackR 2021)
}
