% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_vs_vsdtc_after_dd.R
\name{check_vs_vsdtc_after_dd}
\alias{check_vs_vsdtc_after_dd}
\title{Check for VS dates occurring after death date}
\usage{
check_vs_vsdtc_after_dd(AE, DS, VS)
}
\arguments{
\item{AE}{Adverse Event SDTM dataset with variables USUBJID,
AEDTHDTC, AESTDTC, AEDECOD, and AETERM}

\item{DS}{Disposition SDTM dataset with variables USUBJID,
DSSTDTC, DSDECOD, and DSTERM}

\item{VS}{Vital Signs SDTM dataset with variables USUBJID,
VSDTC, VSTESTCD, and VSORRES}
}
\value{
Boolean value for whether the check passed or failed, with 'msg'
attribute if the check failed
}
\description{
This check looks for VS dates that occur after death date
}
\examples{

AE <- data.frame(STUDYID = 1:5, USUBJID = LETTERS[1:5],
                 AEDTHDTC = c(rep("", 4), "2016-01-01"),
                 AESTDTC = rep("2016-01-01", 5),
                 AEDECOD = LETTERS[1:5], AETERM = LETTERS[1:5],
                 stringsAsFactors = FALSE)

DS <- data.frame(STUDYID = 1:5, USUBJID = LETTERS[1:5],
                 DSSTDTC = rep("2016-01-02", 5),
                 DSDECOD = c(LETTERS[1:4], "death"),
                 DSTERM = letters[1:5],
                 stringsAsFactors = FALSE)

VS <- data.frame(STUDYID = 1:5, USUBJID = LETTERS[1:5],
                 VSDTC = rep("2015-12-31", 5),
                 VSTESTCD = letters[1:5],
                 VSORRES = 1:5,
                 stringsAsFactors = FALSE)

check_vs_vsdtc_after_dd(AE, DS, VS)

VS$VSDTC[1] <- "2016-01-03"
VS$USUBJID[1] <- VS$USUBJID[5]

check_vs_vsdtc_after_dd(AE, DS, VS)

}
\author{
Nina Ting Qi
}
