% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-processing.R
\name{detect_dupes}
\alias{detect_dupes}
\title{Detect and Remove Duplicate Records}
\usage{
detect_dupes(results, method = "exact", similarity_threshold = 0.85)
}
\arguments{
\item{results}{Standardized search results data frame}

\item{method}{Method for duplicate detection ("exact", "fuzzy", "doi")}

\item{similarity_threshold}{Threshold for fuzzy matching (0-1)}
}
\value{
Data frame with duplicates marked and removed
}
\description{
Detect and Remove Duplicate Records
}
\details{
This function provides three methods for duplicate detection:
\itemize{
\item \strong{exact}: Matches on title and first 100 characters of abstract
\item \strong{fuzzy}: Uses Jaro-Winkler string distance for similarity matching
\item \strong{doi}: Matches based on cleaned DOI strings
}
For fuzzy matching, similarity_threshold should be between 0 and 1, where 1 means
identical strings. A threshold of 0.85 typically works well for academic titles.
}
