% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pubmed-connector.R
\name{search_pubmed}
\alias{search_pubmed}
\title{Search PubMed and Retrieve Articles}
\usage{
search_pubmed(
  search_terms,
  max_results = 200,
  date_range = NULL,
  language = "English"
)
}
\arguments{
\item{search_terms}{Character vector of search terms to use in PubMed query}

\item{max_results}{Maximum number of results to retrieve (default: 200)}

\item{date_range}{Optional date range as c("YYYY-MM-DD", "YYYY-MM-DD")}

\item{language}{Optional language filter (default: "English")}
}
\value{
Data frame containing standardized search results
}
\description{
Searches PubMed using the provided search terms and retrieves article metadata
in a format compatible with searchAnalyzeR analysis functions.
}
\details{
This function connects to PubMed using the rentrez package (if available) or
provides simulated data if the package is not installed. Results are returned
as a standardized data frame ready for use with SearchAnalyzer.
}
\examples{
\donttest{
# Search for diabetes clinical trials
results <- search_pubmed(
  search_terms = c("diabetes", "clinical trial"),
  max_results = 100,
  date_range = c("2020-01-01", "2023-12-31")
)

# Use with SearchAnalyzer
analyzer <- SearchAnalyzer$new(results)
metrics <- analyzer$calculate_metrics()
}

}
