% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/season-package.R
\docType{data}
\name{schz}
\alias{schz}
\title{Schizophrenia Births in Australia, 1930--1971}
\format{
A data frame with 504 observations on the following 6 variables.
\describe{ \item{year}{year of birth} \item{month}{month of
birth} \item{yrmon}{a combination of year and month:
\eqn{year+(month-1)/12}} \item{NBirths}{monthly number of births in
Australia, used as an offset} \item{SczBroad}{monthly number of
schizophrenia births using the broad diagnostic criteria}
\item{SOI}{southern oscillation index} }
}
\source{
From Prof John McGrath and colleagues, The University of Queensland,
Brisbane.
}
\usage{
schz
}
\description{
Monthly number of babies born with schizophrenia in Australia from 1930 to
1971. The national number of births and number of cases are missing for
January 1960 are missing.
}
\examples{

data(schz)
plot(schz$yrmon, schz$SczBroad, type='o', xlab='Date',
     ylab='Number of schizophrenia births')

}
\keyword{datasets}
