% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/segment.R
\name{backtrace}
\alias{backtrace}
\title{Back-tracing step of the \code{segmenTier} algorithm.}
\usage{
backtrace(S, K, multib, nextmax = FALSE, verb = TRUE)
}
\arguments{
\item{S}{matrix S, containing the local scores}

\item{K}{matrix K, containing the position k used for score maximization}

\item{multib}{if multiple k produce the maximal score, take either the
shortest k ("max") or the longest k ("min"); if \code{multib} is set to
"skip" the next unique k will be searched}

\item{nextmax}{proceed backwards while score is increasing before
opening a new segment}

\item{verb}{print messages}
}
\description{
back-tracing step: collect clustered segments from the scoring matrix
\code{S(i,c)} by back-tracing the position \code{j=k} which delivered
the maximal score at position \code{i}.
}
