% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metric-funs.R
\name{metric_functions}
\alias{metric_functions}
\alias{sm_compute}
\alias{sm_metric_subset}
\title{Metric functions}
\usage{
sm_compute(m, metric_id, ...)

sm_metric_subset(m, metric_id = NULL)
}
\arguments{
\item{m}{A \code{segmetric} object.}

\item{metric_id}{A \code{character} vector with metrics id to be computed.}

\item{...}{Any additional argument to compute
a metric (see Details).}
}
\value{
Return a \code{numeric} vector with computed metric.
}
\description{
The \code{sm_compute()} computes a given metric (\code{metric_id} parameter) from
segmentation objects. It compares the reference to the segmentation
polygons using a metric.

A list with all supported metrics can be obtained
by \code{sm_list_metrics()} (see Details for more information).

The \code{sm_metric_subset()} returns the subset used to compute the metrics
in segmetric object.
}
\details{
\itemize{
\item "\code{OS1}" refers to Oversegmentation. Its values range from 0 (optimal) to 1
(Clinton et al., 2010).
\item "\code{US1}" refers to Undersegmentation. Its values range from 0 (optimal) to 1
(Clinton et al., 2010).
\item "\code{OS2}" refers to Oversegmentation. Its values range from 0 (optimal) to 1
(Persello and Bruzzone, 2010).
\item "\code{US2}" refers to Undersegmentation. Its values range from 0 (optimal) to 1
(Persello and Bruzzone, 2010).
\item "\code{OS3}" refers to Oversegmentation. Its values range from 0 (optimal) to 1
(Yang et al., 2014).
\item "\code{US3}" refers to Undersegmentation. Its values range from 0 (optimal) to 1
(Yang et al., 2014).
\item "\code{AFI}" refers to Area Fit Index. Its optimal value is 0 (Lucieer and Stein,
2002; Clinton et al., 2010).
\item "\code{QR}" refers to Quality Rate. Its values range from 0 (optimal) to 1
(Weidner, 2008; Clinton et al., 2010).
\item "\code{D_index}" refers to Index D. Its values range from 0 (optimal) to 1
(Levine and Nazif, 1982; Clinton et al., 2010).
\item "\code{precision}" refers to Precision. Its values range from 0 to 1 (optimal)
(Van Rijsbergen, 1979; Zhang et al., 2015).
\item "\code{recall}" refers to Recall. Its values range from 0 to 1 (optimal) (Van
Rijsbergen, 1979; Zhang et al., 2015).
\item "\code{UMerging}" refers to Undermerging. Its values range from 0 (optimal) to 1
(Levine and Nazif, 1982; Clinton et al., 2010).
\item "\code{OMerging}" refers to Overmerging. Its optimal value is 0
(Levine and Nazif, 1982; Clinton et al., 2010).
\item "\code{M}" refers to Match. Its values range from 0 to 1 (optimal) (Janssen and
Molenaar, 1995; Feitosa et al., 2010).
\item "\code{E}" refers to Evaluation Measure. Its values range from 0 (optimal) to 100
(Carleer et al., 2005).
\item "\code{RAsub}" refers to Relative Area. Its values range from 0 to 1 (optimal)
(Müller et al., 2007; Clinton et al., 2010).
\item "\code{RAsuper}" refers to Relative area. Its values range from 0 to 1 (optimal)
(Müller et al., 2007; Clinton et al., 2010).
\item "\code{PI}" refers to Purity Index. Its values range from 0 to 1 (optimal) (van
Coillie et al., 2008).
\item "\code{Fitness}" refers to Fitness Function. Its optimal value is 0 (Costa et al.,
2008).
\item "\code{ED3}" refers to Euclidean Distance. Its values range from 0 (optimal) to 1
(Yang et al., 2014).
\item "\code{F_measure}" refers to F-measure metric. Its values range from 0 to 1
(optimal) (Van Rijsbergen, 1979; Zhang et al., 2015). It takes the optional
weight argument \code{alpha}, ranging from \code{0.0} to \code{1.0} (the default is \code{0.5}).
\item "\code{IoU}" refers to Intersection over Union metric. Its values range
from 0 to 1 (optimal) (Jaccard, 1912; Rezatofighi et al., 2019).
\item "\code{SimSize}" refers to the similarity size metric. Its values range from
0 to 1 (optimal) (Zhan et al., 2005).
\item "\code{qLoc}"refers to quality of object’s location metric. Its optimal value
is 0 (Zhan et al., 2005).
\item "\code{RPsub}" refers to Relative Position (sub) metric. Optimal value is 0
(Möller et al., 2007, Clinton et al., 2010).
\item "\code{RPsuper}" refers to Relative Position (super) metric. Its values range
from 0 (optimal) to 1 (Möller et al., 2007, Clinton et al., 2010).
\item "\code{OI2} refers to Overlap Index metric. Its values range from 0 to 1
(optimal) (Yang et al., 2017).
}
}
\examples{
# load sample datasets
data("sample_ref_sf", package = "segmetric")
data("sample_seg_sf", package = "segmetric")

# create segmetric object
m <- sm_read(ref_sf = sample_ref_sf, seg_sf = sample_seg_sf)

# compute AFI metric and summarize it
sm_compute(m, "AFI") \%>\% summary()

# compute three metrics and summarize them
sm_compute(m, c("AFI", "OS1", "US2")) \%>\% summary()

# compute OS1, F_measure, and US2 metrics using pipe
m <- sm_compute(m, "OS1") \%>\%
  sm_compute("F_measure") \%>\%
  sm_compute("US2")

# summarize them
summary(m)

}
\references{
A complete list of cited references is available in \code{?segmetric}.
}
\seealso{
\code{sm_list_metrics()}
}
