% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/session-options.R
\name{chromote_options}
\alias{chromote_options}
\alias{selenium_options}
\alias{selenium_server_options}
\alias{selenium_client_options}
\title{Driver options}
\usage{
chromote_options(
  headless = TRUE,
  parent = NULL,
  width = 992,
  height = 1323,
  targetId = NULL,
  wait_ = TRUE,
  auto_events = NULL
)

selenium_options(
  client_options = selenium_client_options(),
  server_options = selenium_server_options()
)

selenium_server_options(
  version = "latest",
  port = 4444L,
  selenium_manager = NULL,
  verbose = FALSE,
  temp = TRUE,
  path = NULL,
  interactive = FALSE,
  echo_cmd = FALSE,
  extra_args = c()
)

selenium_client_options(
  port = 4444L,
  host = "localhost",
  verbose = FALSE,
  capabilities = NULL,
  request_body = NULL,
  timeout = 60
)
}
\arguments{
\item{headless}{Whether to run the browser in headless mode, meaning
that you won't actually be able to see the browser as you control it.
For debugging purposes and interactive use, it is often useful to set
this to \code{FALSE}.}

\item{parent}{The parent chromote session.}

\item{width, height, targetId, wait_, auto_events}{Passed into
\link[chromote:ChromoteSession]{chromote::ChromoteSession$new()}.}

\item{client_options}{A \code{\link[=selenium_client_options]{selenium_client_options()}} object.}

\item{server_options}{A \code{\link[=selenium_server_options]{selenium_server_options()}} object, or \code{NULL} if you
don't want one to be created.}

\item{version}{The version of Selenium server to use.}

\item{port}{The port number to use.}

\item{selenium_manager, verbose, temp, path, interactive, echo_cmd, extra_args}{Passed into \code{\link[selenium:selenium_server]{selenium::selenium_server()}}.}

\item{host, capabilities, request_body, timeout}{Passed into \link[selenium:SeleniumSession]{selenium::SeleniumSession$new()}.}
}
\description{
\code{chromote_options()} and \code{selenium_options()} return a list of options that
can be passed to the \code{options} argument of \code{selenider_session()}.

\code{chromote_options()} allows you to control the creation of a chromote driver
created using \link[chromote:ChromoteSession]{chromote::ChromoteSession$new()}.

\code{selenium_options()} allows you to control the creation of a selenium driver.

\code{selenium_server_options()} should be passed to the \code{server_options}
argument of \code{selenium_options()}, allowing you to control the creation of
the server using \code{\link[selenium:selenium_server]{selenium::selenium_server()}}.

\code{selenium_client_options()} should be passed to the \code{client_options} argument
of \code{selenium_options()}, allowing you to control the creation of a Selenium
client created using
\link[selenium:SeleniumSession]{selenium::SeleniumSession$new()}.
}
