% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/approx_check.R
\name{approx_check}
\alias{approx_check}
\title{Compatibility Check for the '_approx' Functions}
\usage{
approx_check(
  fit,
  print_messages = TRUE,
  multiple_group = TRUE,
  equality_constraint = TRUE
)
}
\arguments{
\item{fit}{The output from \code{lavaan}, such as \code{\link[lavaan:cfa]{lavaan::cfa()}} and
\code{\link[lavaan:sem]{lavaan::sem()}}.}

\item{print_messages}{Logical. If \code{TRUE}, will print messages about the
check. If \code{FALSE}, the messages will be attached to the return value
as an attribute. Default is \code{TRUE}.}

\item{multiple_group}{Logical. Whether multiple-group models are
supported. If yes, the check for multiple-groups models will be
skipped. Default is \code{TRUE}.}

\item{equality_constraint}{Logical. Whether models with
equality constraints are
supported. If yes, the check for equality constraints will be
skipped. Default is \code{TRUE}.}
}
\value{
A single-element vector. If confirmed to be supported, will
return 0. If not confirmed to be support but may still work, return 1.
If confirmed to be not yet supported, will return a negative
number, the value of this number without the negative sign is the
number of tests failed.
}
\description{
Gets a 'lavaan' output and checks whether it is
supported by the functions using the approximate approach.
}
\details{
This function is not supposed to be used by users. It is
called by functions such as \code{\link[=est_change_approx]{est_change_approx()}} to see if the
analysis passed to
it is supported. If not, messages will be printed to indicate why.
}
\examples{

dat <- cfa_dat

mod <-
"
f1 =~ x4 + x5 + x6
"
dat_gp <- dat
dat$gp <- rep(c("gp1", "gp2"), length.out = nrow(dat_gp))

fit01 <- lavaan::sem(mod, dat)
# If supported, returns a zero
approx_check(fit01)

fit05 <- lavaan::cfa(mod, dat, group = "gp")
# If not supported, returns a negative number
approx_check(fit05)

}
\author{
Shu Fai Cheung \url{https://orcid.org/0000-0002-9871-9448}.
}
