% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_rsq.R
\name{add_rsq}
\alias{add_rsq}
\title{Add R-Squares to Endogenous Variables}
\usage{
add_rsq(semPaths_plot, object, digits = 2L, rsq_string = "R2=", ests = NULL)
}
\arguments{
\item{semPaths_plot}{A qgraph object generated by
\code{\link[semPlot]{semPaths}}, or a similar qgraph object
modified by other \link{semptools} functions.}

\item{object}{The object used by semPaths to generate the plot. Use
the same argument name used in \code{\link[semPlot]{semPaths}} to
make the meaning of this argument obvious. Currently only object
of class \code{lavaan} is supported.}

\item{digits}{Integer indicating number of decimal places for the
R-squares. Default is 2L.}

\item{rsq_string}{The string before the
R-squares. Default is \code{"R2="}.}

\item{ests}{A data.frame from the
\code{\link[lavaan]{parameterEstimates}} function, or
from other function with these columns:? \code{lhs}, \code{op},
\code{rhs}, and \code{est}. The rows with \code{op} equal to \code{r2}
are used to find the R-squares. Only used when
\code{object} is not specified.}
}
\value{
If the input is a \link[qgraph:qgraph]{qgraph::qgraph} object, the function
returns a qgraph based on the original one, with R-squares
added. If the input is a list of qgraph objects, the
function returns a list of the same length.
}
\description{
Replace the residual variances of exogenous
variables by their R-squares in a \link[qgraph:qgraph]{qgraph::qgraph} object.
}
\details{
Modify a \link[qgraph:qgraph]{qgraph::qgraph} object generated by
\code{\link[semPlot]{semPaths}} by setting the labels
of the residuals of endogenous variables to their
R-squares.

Require either the original object used in the semPaths call,
or a data frame with the R-square for each endogenous
variable.

Currently supports only plots based on \code{\link[lavaan]{lavaan}}
output.
}
\examples{
mod_pa <-
  'x1 ~~ x2
   x3 ~  x1 + x2
   x4 ~  x1 + x3
  '
fit_pa <- lavaan::sem(mod_pa, pa_example)
lavaan::parameterEstimates(fit_pa)[ , c("lhs", "op", "rhs",
                                       "est", "pvalue", "se")]
m <- matrix(c("x1",   NA,   NA,
               NA, "x3", "x4",
             "x2",   NA,   NA), byrow = TRUE, 3, 3)
p_pa <- semPlot::semPaths(fit_pa, whatLabels = "est",
                         style = "ram",
                         nCharNodes = 0, nCharEdges = 0,
                         layout = m)
p_pa2 <- add_rsq(p_pa, fit_pa)
plot(p_pa2)

mod_cfa <-
 'f1 =~ x01 + x02 + x03
  f2 =~ x04 + x05 + x06 + x07
  f3 =~ x08 + x09 + x10
  f4 =~ x11 + x12 + x13 + x14
 '
fit_cfa <- lavaan::sem(mod_cfa, cfa_example)
lavaan::parameterEstimates(fit_cfa)[ , c("lhs", "op", "rhs",
                                        "est", "pvalue", "se")]
p_cfa <- semPlot::semPaths(fit_cfa, whatLabels = "est",
                          style = "ram",
                          nCharNodes = 0, nCharEdges = 0)
# Place standard errors on a new line
p_cfa2 <- add_rsq(p_cfa, fit_cfa)
plot(p_cfa2)

mod_sem <-
'f1 =~ x01 + x02 + x03
 f2 =~ x04 + x05 + x06 + x07
 f3 =~ x08 + x09 + x10
 f4 =~ x11 + x12 + x13 + x14
 f3 ~  f1 + f2
 f4 ~  f1 + f3
'

# Can be used with mark_se() and mark_sig()
fit_sem <- lavaan::sem(mod_sem, sem_example)
lavaan::parameterEstimates(fit_sem)[ , c("lhs", "op", "rhs",
                                        "est", "pvalue", "se")]
p_sem <- semPlot::semPaths(fit_sem, whatLabels = "est",
                          style = "ram",
                          nCharNodes = 0, nCharEdges = 0)
# Mark significance, and then add standard errors
p_sem2 <- mark_sig(p_sem, fit_sem)
p_sem3 <- mark_se(p_sem2, fit_sem, sep = "\n")
p_sem4 <- add_rsq(p_sem3, fit_sem)
plot(p_sem4)

}
