% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/render_version.R
\name{render_version}
\alias{render_version}
\alias{render_version.svptr}
\alias{render_version.svlist}
\title{Render semantic version}
\usage{
render_version(x, ...)

\method{render_version}{svptr}(x, ...)

\method{render_version}{svlist}(x, ...)
}
\arguments{
\item{x}{An object of class "svlist" or "svptr".}

\item{...}{Additional arguments passed on to methods.}
}
\value{
A list of semantic versions represented as integers (major,
    minor, patch) and characters (prerelease, build)
}
\description{
Render a semantic version list or a semantic version pointer as an
R list giving the major, minor and patch version as an integer and the
prerelease and build version as a charcter
}
\examples{
semver <- parse_version(c("1.2.3", "1.2.4", "1.0.0", "1.2.4-beta+2", "2.1.3-alpha", "1.9.4"))
render_version(semver[[4]])
render_version(semver)
}
