% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R
\name{print.sensemakr}
\alias{print.sensemakr}
\alias{summary.sensemakr}
\alias{ovb_minimal_reporting}
\title{Sensitivity analysis print and summary methods for \code{sensemakr}}
\usage{
\method{print}{sensemakr}(x, digits = max(3L, getOption("digits") - 2L), ...)

\method{summary}{sensemakr}(object, digits = max(3L, getOption("digits") - 3L), ...)

ovb_minimal_reporting(
  x,
  digits = 3,
  verbose = TRUE,
  format = c("latex", "html", "pure_html"),
  ...
)
}
\arguments{
\item{x}{an object of class \code{\link{sensemakr}}.}

\item{digits}{minimal number of \emph{significant} digits.}

\item{...}{arguments passed to other methods.}

\item{object}{an object of class \code{\link{sensemakr}}.}

\item{verbose}{if `TRUE`, the function prints the LaTeX code with \code{\link{cat}}}

\item{format}{code format to print, either \code{latex} or \code{html}. The default html version
has some mathematical content that requires mathjax or equivalent library to parse.
If you need only html, use the option "pure_html".}
}
\value{
The function \code{ovb_minimal_reporting} returns the LaTeX/HTML code invisibly in character form and also prints with
\code{\link{cat}} the LaTeX code. To suppress automatic printing, set \code{verbose = FALSE}.
}
\description{
The \code{print} and \code{summary} methods provide verbal descriptions of the sensitivity analysis results
obtained with the function \code{\link{sensemakr}}. The function \code{\link{ovb_minimal_reporting}} provides
latex or html code for a minimal
sensitivity analysis reporting, as suggested in Cinelli and Hazlett (2020).
}
\examples{
# runs regression model
model <- lm(peacefactor ~ directlyharmed + age + farmer_dar + herder_dar +
                         pastvoted + hhsize_darfur + female + village,
                         data = darfur)

# runs sensemakr for sensitivity analysis
sensitivity <- sensemakr(model, treatment = "directlyharmed",
                               benchmark_covariates = "female",
                               kd = 1:3)
# print
sensitivity

# summary
summary(sensitivity)

# prints latex code for minimal sensitivity analysis reporting
ovb_minimal_reporting(sensitivity)

}
\references{
Cinelli, C. and Hazlett, C. (2020), "Making Sense of Sensitivity: Extending Omitted Variable Bias." Journal of the Royal Statistical Society, Series B (Statistical Methodology).
}
