% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survey_functions.R
\name{summarize_sensitivity_survey}
\alias{summarize_sensitivity_survey}
\title{Sensitivity Summary (for survey weights)}
\usage{
summarize_sensitivity_survey(svy_srs, svy_wt, weights, varY, b_star = 0)
}
\arguments{
\item{svy_srs}{Survey object, containing the unweighted survey}

\item{svy_wt}{Survey object, containing the weighted survey}

\item{weights}{A vector, containing the estimated survey weights}

\item{varY}{variance of the outcome}

\item{b_star}{Killer confounder threshold, default set to be zero}
}
\value{
data.frame with summary measures of sensitivity
}
\description{
Returns a data.frame or Kable table with summary measures of sensitivity; helper function for main summary function, and allows users to directly input a survey object and a design object
}
\examples{
data(poll.data)
poll_srs <- survey::svydesign(ids = ~ 1, data = poll.data)
pop_targets = c(1, 0.212, 0.264, 0.236, 0.310, 
                0.114, 0.360, 0.528, 0.114, 
                0.021, 0.034, 0.805, 
                0.266, 0.075, 0.312, 0.349)
names(pop_targets) = c("(Intercept)",
                       "age_buckets36to50",
                       "age_buckets51to64",
                       "age_bucketsOver65",
                       "educHigh School or Less",
                       "educPost-grad",
                       "educSome college",
                       "genderWomen", 
                       "raceBlack",
                       "raceHispanic",
                       "raceOther",
                       "raceWhite", 
                       "pidIndependent", "pidOther", 
                       "pidRepublican", "bornagainYes")
#Set up raking formula:
formula_rake <- ~ age_buckets + educ + gender + race + pid + bornagain

#PERFORM RAKING:
model_rake <- survey::calibrate(
  design = poll_srs,
  formula = formula_rake,
  population = pop_targets,
  calfun = "raking",
  force = TRUE
)


rake_results <- survey::svydesign( ~ 1, data = poll.data, weights = stats::weights(model_rake))
#Estimate from raking results:
weights = stats::weights(rake_results) * nrow(model_rake)

unweighted_estimate = survey::svymean(~ Y, poll_srs, na.rm = TRUE)
weighted_estimate = survey::svymean(~ Y, model_rake, na.rm = TRUE)
summarize_sensitivity(estimand = 'Survey',
Y = poll.data$Y,
weights = weights,
svy_srs = unweighted_estimate, 
svy_wt = weighted_estimate,
b_star = 0.5)
}
