% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fanhmm_leaves.R
\docType{data}
\name{leaves}
\alias{leaves}
\title{Synthetic data on fathers' parental leaves in Finland}
\format{
A \code{data.table} with 9281 rows and 9 variables
}
\description{
Synthetic data on fathers' parental leaves in Finland
}
\details{
The \code{leaves} data is a synthetic version of the Finnish fathers' leave-taking
data used in Helske et al. (2024) and Helske (2025). The data consists of
variables
\itemize{
\item workplace: Workplace ID.
\item father: father ID within workplace. More accurately, this is the birth of
a child, i.e. same father can have multiple entries in data, but each entry
has separate ID.
\item year: Year when the child was born.
\item leave: Factor of leave-taking of the father.
\item Occupation: Factor of skill level of the father's occupation
\item reform2013: Factor indicating whether the father was eligible for the leave
under the 2013 reform.
\item same_occupation: Logical value, TRUE if father had same occupation as the
previous father.
\item lag_reform2013: Factor indicating whether the previous father was
eligible for the reform.
\item lag_occupation: Factor indiciting the occupation of previous father.
}
}
\examples{
data("leaves")
head(leaves)
# convert to stslist
leaves_sequences <- data_to_stslist(
  leaves, id = "workplace", time = "father", responses = "leave",
  seqdef_args = list(cpal = c("tomato", "navyblue", "goldenrod"))
)
stacked_sequence_plot(leaves_sequences)
}
\references{
Helske S, Helske J, Chapman SN, Kotimäki S, Salin M, and Tikka S (2024).
Heterogeneous workplace peer effects in fathers’ parental leave uptake in Finland.
doi: 10.31235/osf.io/p3chf
Helske J (2025). Feedback-augmented Non-homogeneous Hidden Markov Models for Longitudinal Causal Inference.
ArXiv preprint. doi:10.48550/arXiv.2503.16014
}
\keyword{datasets}
