% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_seromodel.R
\name{set_foi_init}
\alias{set_foi_init}
\title{Sets initialization function for sampling}
\usage{
set_foi_init(foi_init, is_log_foi, foi_index)
}
\arguments{
\item{foi_init}{Initialization function for sampling. If null, default is
chosen depending on the foi-scale of the model}

\item{is_log_foi}{Boolean to set logarithmic scale in the FoI}

\item{foi_index}{Integer vector specifying the age-groups for which
Force-of-Infection values will be estimated. It can be specified by
means of \link{get_foi_index}}
}
\value{
Function specifying initialization vector for the Force-of-Infection
}
\description{
Sets initialization function for sampling
}
\examples{
data(chagas2012)
foi_index <- get_foi_index(chagas2012, group_size = 5, model_type = "age")
foi_init <- set_foi_init(
  foi_init = NULL,
  is_log_foi = FALSE,
  foi_index = foi_index
)
}
