% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{hav_bg_1964}
\alias{hav_bg_1964}
\title{Hepatitis A serological data from Bulgaria in 1964 (aggregated)}
\format{
A data frame with 3 variables:
\describe{
 \item{age}{Age group}
 \item{pos}{Number of seropositive individuals}
 \item{tot}{Total number of individuals surveyed}
}
}
\source{
Keiding, Niels. "Age-Specific Incidence and Prevalence: A
Statistical Perspective." Journal of the Royal Statistical Society.
Series A (Statistics in Society) 154, no. 3 (1991): 371-412.
\doi{doi:10.2307/2983150}
}
\usage{
hav_bg_1964
}
\description{
A cross-sectional survey conducted in 1964 in Bulgaria. Samples were
collected from schoolchildren and blood donors.
}
\examples{
# Reproduce Fig 4.1 (lower panel), p. 63
age <- hav_bg_1964$age
pos <- hav_bg_1964$pos
tot <- hav_bg_1964$tot
plot(
    age, pos / tot,
    pty = "s", cex = 0.08 * tot, pch = 16, xlab = "age",
    ylab = "seroprevalence", xlim = c(0, 86), ylim = c(0, 1)
)

}
\keyword{datasets}
